//Copyright (C)2002 Peter Mertens <peter@pmertens.de>.  
package de.pmertens;
 
import java.util.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
 
//Klasse Datum stellt Methoden fr Vergleiche von Datmern
//zur Verfgung.
//Autor: Peter Mertens
//Version 1.0
public class Datum {
    //Klassenfelder:
    
    //Datumsformat yyyy.mm.dd definieren
    private static final DateFormat datumformat;
        
    //aktuelles Datum
    private static final Date aktDat;
    private static final String aktuellesDatum;
    private static final Datum aktuelles;
    
    //statischer Initialisierer fr Klassenfelder
    static {
        aktDat= new Date();
        datumformat= new SimpleDateFormat("yyyy.MM.dd");
        aktuellesDatum= datumformat.format(aktDat);
        aktuelles= new Datum(aktuellesDatum);
    }
    
    //Instanzfeld
    private String datum;
    
    //Konstruktormethoden
    public Datum () {
        this("1980.01.01");
    }
    public Datum (String dat) {
        this.datum= dat;
    }
    
    //Instanzmethode gibt Inhalt des Instanzfeldes datum zurck
    public String getdatum() {
        return this.datum;
    }
    
    //Instanzmethode setzt Inhalt des Instanzfeldes datum
    public void setdatum(String neu ) {
        this.datum= neu;
    }
    
    //Klassenmethode gibt Inhalt des Klassenfeldes aktuellesDatum zurck
    public static String getaktuellesDatum() {
        return aktuellesDatum;
    }
    
    //Instanzmethode berprft, ob Instanzdatum gleichen Jahrestag
    //wie aktuelles Datum hat.
    public boolean gleicherJahrestagwieaktuellesDatum() {
        return this.gleicherJahrestag( aktuelles);
    }
    
    //Instanzmethode berprft, ob Instanzdatum gleichen Jahrestag
    //wie bergebenes Datum hat.
    public boolean gleicherJahrestag( Datum datum1) {
        String datum_mt= this.datum.substring( 5, 10);
        String datum1_mt= datum1.datum.substring( 5, 10);
        
        if ( 0 == datum_mt.compareTo( datum1_mt))
            return true;
        else
            return false;
    }
    
    //Instanzmethode berprft, ob Jahrestag des Instanzdatum zwischen
    //Jahrestagen des bergebenen Datum und dem aktuellen Datum liegt.
    //datum1 < this.datum < aktuelles Datum
    public boolean zwischenJahrestag_aktuellesDatum( Datum datum1) {
        return this.zwischenJahrestag( datum1, aktuelles);
    }
    
    //Instanzmethode berprft, ob Jahrestag des Instanzdatum zwischen
    //Jahresdatmern der bergebenen Datmer liegt.
    //datum1 < this.datum < datum2
    public boolean zwischenJahrestag(Datum datum1, Datum datum2) {
        String datum1_mt= datum1.datum.substring( 5, 10);
        String datum_mt= this.datum.substring( 5, 10);
        String datum2_mt= datum2.datum.substring( 5, 10);
        
        //berprfung, ob Jahreswechsel zwischen
        //datum1_mt und datum2_mt vorliegt
        if (0 < datum1_mt.compareTo( datum2_mt) )
        {
            //Jahreswechsel
            if ( (0 > datum1_mt.compareTo( datum_mt) ) ||
                (0 > datum_mt.compareTo( datum2_mt) ) )
                return true; //datum1 < this.datum < datum2
            else
                return false;
        }
        else
        {
            //kein Jahreswechsel
            if ( (0 > datum1_mt.compareTo( datum_mt) ) &&
                (0 > datum_mt.compareTo( datum2_mt) ) )
                return true; //datum1 < this.datum < datum2
            else
                return false;
        }
    }
}